"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthService = void 0;
const common_1 = require("@nestjs/common");
const users_service_1 = require("../users/users.service");
const jwt_1 = require("@nestjs/jwt");
const admin_service_1 = require("../admin/admin.service");
let AuthService = class AuthService {
    userService;
    jwtService;
    adminService;
    constructor(userService, jwtService, adminService) {
        this.userService = userService;
        this.jwtService = jwtService;
        this.adminService = adminService;
    }
    async loginAdmin(nationalCode, password) {
        const user = await this.adminService.loginAdminUser(nationalCode);
        const accessToken = this.jwtService.sign({
            sub: user._id,
            nationalCode: user.nationalCode
        });
        return { user, token: { accessToken } };
    }
    async loginWithPhoneNumber(phoneNumber) {
        const user = await this.userService.findByPhoneNumber(phoneNumber);
        if (!user) {
            throw new common_1.BadRequestException('کاربر مورد نظر یافت نشد!');
        }
        const accessToken = this.jwtService.sign({
            sub: user._id,
            nationalCode: user.nationalCode
        });
        return { data: user, token: { accessToken } };
    }
    async loginWithUserPass(userName, password) {
        const user = await this.userService.loginWithUserPass(userName, password);
        if (!user) {
            throw new common_1.BadRequestException('کاربر مورد نظر یافت نشد!');
        }
        const accessToken = this.jwtService.sign({
            sub: user._id,
            nationalCode: user.nationalCode
        });
        return { data: user, token: { accessToken } };
    }
};
exports.AuthService = AuthService;
exports.AuthService = AuthService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [users_service_1.UsersService,
        jwt_1.JwtService, admin_service_1.AdminService])
], AuthService);
//# sourceMappingURL=auth.service.js.map