"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvestmentWorker = void 0;
const common_1 = require("@nestjs/common");
const mongoose_1 = require("@nestjs/mongoose");
const investment_entity_1 = require("./entities/investment.entity");
const mongoose_2 = require("mongoose");
const schedule_1 = require("@nestjs/schedule");
const process_settings_service_1 = require("../process-settings/process-settings.service");
let InvestmentWorker = class InvestmentWorker {
    investmentModel;
    processSettingsService;
    constructor(investmentModel, processSettingsService) {
        this.investmentModel = investmentModel;
        this.processSettingsService = processSettingsService;
    }
    async handleCron() {
        const now = new Date();
        console.log('cron is running at:', now);
        const deadline = await this.processSettingsService.getDeadlineTime();
        console.log(deadline);
        const createdTime = new Date(Date.now() - (deadline * 60 * 1000));
        const investments = await this.investmentModel.updateMany({ status: 'pending', createdAt: { $lte: createdTime } }, [{
                $set: {
                    status: 'created',
                    endTime: { $add: [
                            { $toDate: now }, { $multiply: ['$time', 30, 24, 60, 60, 1000] }
                        ] }
                }
            }]);
        console.log(investments);
    }
};
exports.InvestmentWorker = InvestmentWorker;
__decorate([
    (0, schedule_1.Cron)(`*/1 * * * *`),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], InvestmentWorker.prototype, "handleCron", null);
exports.InvestmentWorker = InvestmentWorker = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_1.InjectModel)(investment_entity_1.Investment.name)),
    __metadata("design:paramtypes", [mongoose_2.Model,
        process_settings_service_1.ProcessSettingsService])
], InvestmentWorker);
//# sourceMappingURL=investment-worker.js.map