"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProcessSettingSchema = exports.ProcessSetting = exports.ProcessType = exports.RangeString = exports.Range = void 0;
const mongoose_1 = require("@nestjs/mongoose");
const class_validator_1 = require("class-validator");
let Range = class Range {
    start;
    end;
};
exports.Range = Range;
__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, mongoose_1.Prop)({ type: Number }),
    __metadata("design:type", Number)
], Range.prototype, "start", void 0);
__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, mongoose_1.Prop)({ type: Number }),
    __metadata("design:type", Number)
], Range.prototype, "end", void 0);
exports.Range = Range = __decorate([
    (0, mongoose_1.Schema)({ _id: false })
], Range);
let RangeString = class RangeString {
    start;
    end;
};
exports.RangeString = RangeString;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, mongoose_1.Prop)({ type: String }),
    __metadata("design:type", String)
], RangeString.prototype, "start", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, mongoose_1.Prop)({ type: String }),
    __metadata("design:type", String)
], RangeString.prototype, "end", void 0);
exports.RangeString = RangeString = __decorate([
    (0, mongoose_1.Schema)({ _id: false })
], RangeString);
var ProcessType;
(function (ProcessType) {
    ProcessType["CREATE"] = "create";
    ProcessType["IN_PROGRESS"] = "inProgress";
    ProcessType["COMPLETE"] = "complete";
})(ProcessType || (exports.ProcessType = ProcessType = {}));
let ProcessSetting = class ProcessSetting {
    process;
    time;
    deadline;
    counterParticle;
    speed;
    distance;
    speedFade;
    particleColor;
    lineColor;
    text;
};
exports.ProcessSetting = ProcessSetting;
__decorate([
    (0, mongoose_1.Prop)({ type: String, enum: ProcessType, default: ProcessType.CREATE }),
    __metadata("design:type", String)
], ProcessSetting.prototype, "process", void 0);
__decorate([
    (0, mongoose_1.Prop)({ type: Number }),
    __metadata("design:type", Number)
], ProcessSetting.prototype, "time", void 0);
__decorate([
    (0, mongoose_1.Prop)({ type: Number }),
    __metadata("design:type", Number)
], ProcessSetting.prototype, "deadline", void 0);
__decorate([
    (0, mongoose_1.Prop)({ type: Range, default: { start: 0, end: 0 } }),
    __metadata("design:type", Range)
], ProcessSetting.prototype, "counterParticle", void 0);
__decorate([
    (0, mongoose_1.Prop)({ type: Range, default: { start: 0, end: 0 } }),
    __metadata("design:type", Range)
], ProcessSetting.prototype, "speed", void 0);
__decorate([
    (0, mongoose_1.Prop)({ type: Range, default: { start: 0, end: 0 } }),
    __metadata("design:type", Range)
], ProcessSetting.prototype, "distance", void 0);
__decorate([
    (0, mongoose_1.Prop)({ type: Range, default: { start: 0, end: 0 } }),
    __metadata("design:type", Range)
], ProcessSetting.prototype, "speedFade", void 0);
__decorate([
    (0, mongoose_1.Prop)({ type: RangeString, default: { start: '#aaaaaa', end: '#000000' } }),
    __metadata("design:type", RangeString)
], ProcessSetting.prototype, "particleColor", void 0);
__decorate([
    (0, mongoose_1.Prop)({ type: RangeString, default: { start: '#aaaaaa', end: '#000000' } }),
    __metadata("design:type", RangeString)
], ProcessSetting.prototype, "lineColor", void 0);
__decorate([
    (0, mongoose_1.Prop)({ type: RangeString, default: { start: 'start', end: 'end' } }),
    __metadata("design:type", RangeString)
], ProcessSetting.prototype, "text", void 0);
exports.ProcessSetting = ProcessSetting = __decorate([
    (0, mongoose_1.Schema)({ timestamps: true })
], ProcessSetting);
exports.ProcessSettingSchema = mongoose_1.SchemaFactory.createForClass(ProcessSetting);
//# sourceMappingURL=process-setting.entity.js.map