"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProcessSettingsController = void 0;
const common_1 = require("@nestjs/common");
const process_settings_service_1 = require("./process-settings.service");
const update_process_setting_dto_1 = require("./dto/update-process-setting.dto");
let ProcessSettingsController = class ProcessSettingsController {
    processSettingsService;
    constructor(processSettingsService) {
        this.processSettingsService = processSettingsService;
    }
    async createProcessSetting(process) {
        return await this.processSettingsService.createProcess(process);
    }
    async getDeadlineTime() {
        return await this.processSettingsService.getDeadlineTime();
    }
    async getProcess(process) {
        return await this.processSettingsService.getProcess(process);
    }
    async updateDeadlineTime(body) {
        return await this.processSettingsService.updateDeadlineTime(body.deadlineTime);
    }
    async updateAllData(process, updateProcessSettingsDto) {
        console.log(updateProcessSettingsDto);
        return await this.processSettingsService.updateAllData(process, updateProcessSettingsDto);
    }
    async updateKVSettingWithoutStartEnd(body) {
        return await this.processSettingsService.updateKVSettingWithoutStartEnd(body.process, body.key, body.value);
    }
    async updateKVSettingWithStartEnd(body) {
        return await this.processSettingsService.updateKVSettingWithStartEnd(body.process, body.key, body.sOrE, body.value);
    }
};
exports.ProcessSettingsController = ProcessSettingsController;
__decorate([
    (0, common_1.Post)('create'),
    __param(0, (0, common_1.Body)('process')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], ProcessSettingsController.prototype, "createProcessSetting", null);
__decorate([
    (0, common_1.Get)('deadline-time'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ProcessSettingsController.prototype, "getDeadlineTime", null);
__decorate([
    (0, common_1.Get)('type/:process'),
    __param(0, (0, common_1.Param)('process')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], ProcessSettingsController.prototype, "getProcess", null);
__decorate([
    (0, common_1.Patch)('update/deadline'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], ProcessSettingsController.prototype, "updateDeadlineTime", null);
__decorate([
    (0, common_1.Patch)('update/all/:process'),
    __param(0, (0, common_1.Param)('process')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_process_setting_dto_1.UpdateProcessSettingDto]),
    __metadata("design:returntype", Promise)
], ProcessSettingsController.prototype, "updateAllData", null);
__decorate([
    (0, common_1.Patch)('update/props/kv'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], ProcessSettingsController.prototype, "updateKVSettingWithoutStartEnd", null);
__decorate([
    (0, common_1.Patch)('update/props/kvo'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], ProcessSettingsController.prototype, "updateKVSettingWithStartEnd", null);
exports.ProcessSettingsController = ProcessSettingsController = __decorate([
    (0, common_1.Controller)('process-settings'),
    __metadata("design:paramtypes", [process_settings_service_1.ProcessSettingsService])
], ProcessSettingsController);
//# sourceMappingURL=process-settings.controller.js.map