"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProcessSettingsService = void 0;
const common_1 = require("@nestjs/common");
const mongoose_1 = require("@nestjs/mongoose");
const process_setting_entity_1 = require("./entities/process-setting.entity");
const mongoose_2 = require("mongoose");
let ProcessSettingsService = class ProcessSettingsService {
    processSettingModel;
    constructor(processSettingModel) {
        this.processSettingModel = processSettingModel;
    }
    async createProcess(process) {
        const createdProcessSetting = await this.processSettingModel.create({
            process, deadline: 0, time: 0,
            speed: { start: 0, end: 0 },
            distance: { start: 0, end: 0 },
            speedFade: { start: 0, end: 0 },
            counterParticle: { start: 0, end: 0 }
        });
        if (!createdProcessSetting)
            throw new Error('خطا در ایجاد تنظیمات فرآیند!');
        return createdProcessSetting;
    }
    async getDeadlineTime() {
        const processSettings = await this.processSettingModel.findOne({ process: 'create' });
        if (!processSettings)
            throw new common_1.NotFoundException('تنظیمات فرآیند یافت نشد!');
        if (processSettings?.deadline != undefined) {
            const deadlineTime = processSettings?.deadline / (60 * 1000);
            return deadlineTime;
        }
        return (processSettings?.deadline || 0);
    }
    async getProcess(process) {
        const processSetting = await this.processSettingModel.findOne({ process });
        if (!process)
            throw new common_1.NotFoundException('پردازش  مورد نظر یافت نشد!');
        return processSetting;
    }
    async updateDeadlineTime(deadlineTime) {
        const processSetting = await this.processSettingModel.findOneAndUpdate({ process: 'create' }, { deadline: deadlineTime * 60 * 60 * 1000 });
        if (!processSetting)
            throw new common_1.NotFoundException('فرآیند مورد نظر یافت نشد!');
        processSetting.deadline = deadlineTime * 60 * 1000;
        await processSetting.save();
        return processSetting;
    }
    async updateKVSettingWithoutStartEnd(process, key, value) {
        const keyAllowed = ["time"];
        if (!keyAllowed.includes(key))
            throw new common_1.BadRequestException('ویژگی مورد نظر مجاز نیست!');
        const processSetting = await this.processSettingModel.findOneAndUpdate({ process }, { [key]: value });
        if (!processSetting)
            throw new common_1.NotFoundException('تنظیمات مورد نظر یافت نشد!');
        return processSetting;
    }
    async updateKVSettingWithStartEnd(process, key, sOrE, value) {
        const keyAllowed = ["counterParticle", "speed", "distance", "speedFade", "particleColor", "lineColor", "text"];
        const sOrEAllowed = ["start", "end"];
        if (!keyAllowed.includes(key))
            throw new common_1.BadRequestException('ویژگی مورد نظر مجاز نیست!');
        if (!sOrEAllowed.includes(sOrE))
            throw new common_1.BadRequestException('ویژگی مورد نظر مجاز نیست!');
        const processSetting = await this.processSettingModel.findOneAndUpdate({ process }, {
            [`${key}.${sOrE}`]: value
        });
        if (!processSetting)
            throw new common_1.NotFoundException('تنظیمات مورد نظر یافت نشد!');
        return processSetting;
    }
    async updateAllData(process, updateProcessSettingDto) {
        const processSetting = await this.processSettingModel.findOneAndUpdate({ process }, updateProcessSettingDto);
        if (!processSetting)
            throw new common_1.NotFoundException('فرآیند مورد نظر یافت نشد!');
        return processSetting;
    }
};
exports.ProcessSettingsService = ProcessSettingsService;
exports.ProcessSettingsService = ProcessSettingsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_1.InjectModel)(process_setting_entity_1.ProcessSetting.name)),
    __metadata("design:paramtypes", [mongoose_2.Model])
], ProcessSettingsService);
//# sourceMappingURL=process-settings.service.js.map