import { Unit, UnitDocument } from './entities/unit.entity';
import { Model } from 'mongoose';
import { CreatedUserService } from 'src/created-user/created-user.service';
import { InvestmentService } from 'src/investment/investment.service';
export declare class UnitsService {
    private unitModel;
    private createdUserService;
    private investmentService;
    constructor(unitModel: Model<UnitDocument>, createdUserService: CreatedUserService, investmentService: InvestmentService);
    createUnit(type: string): Promise<import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, Unit, {}, {}> & Unit & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    }, {}, {}> & import("mongoose").Document<unknown, {}, Unit, {}, {}> & Unit & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    } & Required<{
        _id: import("mongoose").Types.ObjectId;
    }>>;
    findColumnWithTitle(type: string, title: string): Promise<import("./entities/unit.entity").UnitColumn>;
    getUnits(): Promise<(import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, Unit, {}, {}> & Unit & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    }, {}, {}> & import("mongoose").Document<unknown, {}, Unit, {}, {}> & Unit & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    } & Required<{
        _id: import("mongoose").Types.ObjectId;
    }>)[]>;
    getColumnsOfUnit(type: string): Promise<({
        column: import("./entities/unit.entity").UnitColumn;
        users: {
            user: import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, import("src/users/entities/user.entity").User, {}, {}> & import("src/users/entities/user.entity").User & {
                _id: import("mongoose").Types.ObjectId;
            } & {
                __v: number;
            }, {}, {}> & import("mongoose").Document<unknown, {}, import("src/users/entities/user.entity").User, {}, {}> & import("src/users/entities/user.entity").User & {
                _id: import("mongoose").Types.ObjectId;
            } & {
                __v: number;
            } & Required<{
                _id: import("mongoose").Types.ObjectId;
            }>;
            investment: any;
        }[];
    } | {
        column: {
            title: string;
            activate: boolean;
            totalAmount: number;
            finalAmount: number;
            benefit: number;
        };
        users: ((import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, import("../created-user/entities/created-user.entity").CreatedUser, {}, {}> & import("../created-user/entities/created-user.entity").CreatedUser & {
            _id: import("mongoose").Types.ObjectId;
        } & {
            __v: number;
        }, {}, {}> & import("mongoose").Document<unknown, {}, import("../created-user/entities/created-user.entity").CreatedUser, {}, {}> & import("../created-user/entities/created-user.entity").CreatedUser & {
            _id: import("mongoose").Types.ObjectId;
        } & {
            __v: number;
        } & Required<{
            _id: import("mongoose").Types.ObjectId;
        }>) | {
            user: import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, import("src/users/entities/user.entity").User, {}, {}> & import("src/users/entities/user.entity").User & {
                _id: import("mongoose").Types.ObjectId;
            } & {
                __v: number;
            }, {}, {}> & import("mongoose").Document<unknown, {}, import("src/users/entities/user.entity").User, {}, {}> & import("src/users/entities/user.entity").User & {
                _id: import("mongoose").Types.ObjectId;
            } & {
                __v: number;
            } & Required<{
                _id: import("mongoose").Types.ObjectId;
            }>;
        })[];
    })[]>;
    createColumnOfUnit(type: string, title: string): Promise<import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, Unit, {}, {}> & Unit & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    }, {}, {}> & import("mongoose").Document<unknown, {}, Unit, {}, {}> & Unit & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    } & Required<{
        _id: import("mongoose").Types.ObjectId;
    }>>;
    changeActivateColumn(type: string, titleColumn: string): Promise<import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, Unit, {}, {}> & Unit & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    }, {}, {}> & import("mongoose").Document<unknown, {}, Unit, {}, {}> & Unit & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    } & Required<{
        _id: import("mongoose").Types.ObjectId;
    }>>;
    autoUpdateAmountsColumn(type: string, key: string, titleColumn: string): Promise<(import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, Unit, {}, {}> & Unit & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    }, {}, {}> & import("mongoose").Document<unknown, {}, Unit, {}, {}> & Unit & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    } & Required<{
        _id: import("mongoose").Types.ObjectId;
    }>) | undefined>;
    updateFinalAmountWithOnChange(type: string, titleColumn: string, finalAmount: number): Promise<void>;
    updateFinalAmountColumn(type: string, columnsUpdate: Array<{
        title: string;
        finalAmount: number;
    }>): Promise<(import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, Unit, {}, {}> & Unit & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    }, {}, {}> & import("mongoose").Document<unknown, {}, Unit, {}, {}> & Unit & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    } & Required<{
        _id: import("mongoose").Types.ObjectId;
    }>) | undefined>;
    updateColumnAmountAddItem(type: string, title: string, amount: number): Promise<import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, Unit, {}, {}> & Unit & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    }, {}, {}> & import("mongoose").Document<unknown, {}, Unit, {}, {}> & Unit & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    } & Required<{
        _id: import("mongoose").Types.ObjectId;
    }>>;
    updateColumnAmountItemLeaveColumn(type: string, title: string, amount: number): Promise<import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, Unit, {}, {}> & Unit & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    }, {}, {}> & import("mongoose").Document<unknown, {}, Unit, {}, {}> & Unit & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    } & Required<{
        _id: import("mongoose").Types.ObjectId;
    }>>;
    updateAllAmountColumn(type: string): Promise<(import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, Unit, {}, {}> & Unit & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    }, {}, {}> & import("mongoose").Document<unknown, {}, Unit, {}, {}> & Unit & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    } & Required<{
        _id: import("mongoose").Types.ObjectId;
    }>) | undefined>;
    deleteColumn(type: string, titleColumn: string): Promise<import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, Unit, {}, {}> & Unit & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    }, {}, {}> & import("mongoose").Document<unknown, {}, Unit, {}, {}> & Unit & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    } & Required<{
        _id: import("mongoose").Types.ObjectId;
    }>>;
}
