"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UnitsService = void 0;
const common_1 = require("@nestjs/common");
const mongoose_1 = require("@nestjs/mongoose");
const unit_entity_1 = require("./entities/unit.entity");
const mongoose_2 = require("mongoose");
const created_user_service_1 = require("../created-user/created-user.service");
const investment_service_1 = require("../investment/investment.service");
let UnitsService = class UnitsService {
    unitModel;
    createdUserService;
    investmentService;
    constructor(unitModel, createdUserService, investmentService) {
        this.unitModel = unitModel;
        this.createdUserService = createdUserService;
        this.investmentService = investmentService;
    }
    async createUnit(type) {
        const unit = await this.unitModel.create({ type, columns: [] });
        if (!unit)
            throw new common_1.BadRequestException('خطا در ایجاد المان!');
        return unit;
    }
    async findColumnWithTitle(type, title) {
        const unit = await this.unitModel.findOne({ type });
        if (!unit)
            throw new common_1.NotFoundException('واحد مورد نظر یافت نشد!');
        const column = unit.columns?.find(item => item.title == title);
        if (!column)
            throw new common_1.NotFoundException('ستون مورد نظر یافت نشد!');
        return column;
    }
    async getUnits() {
        const units = await this.unitModel.find();
        return units;
    }
    async getColumnsOfUnit(type) {
        await this.updateAllAmountColumn(type);
        const existingUnit = await this.unitModel.findOne({ type });
        if (!existingUnit)
            throw new common_1.NotFoundException('واحد مورد نظر یافت نشد!');
        if (existingUnit?.columns) {
            const userCreated = await this.createdUserService.getUsers(type);
            const investmentsPending = await this.investmentService.getInvestmentPending(type);
            const completedInvestments = await this.investmentService.getInvestmentCompleted(type);
            const columnsGroupedWithInvestment = await Promise.all(existingUnit.columns.filter(item => item.activate == true).map(async (item) => {
                let investments = await this.investmentService.getInvestmentWithTypeAndPercent(type, Number(item.title));
                if (!investments)
                    throw new common_1.BadRequestException('خطا در دریافت درخواست ها!');
                return { column: item, users: investments };
            }));
            const columnsGrouped = [
                {
                    column: { title: 'created', activate: true, totalAmount: 0, finalAmount: 0, benefit: 0 },
                    users: [...(userCreated ? userCreated : []), ...(investmentsPending ? investmentsPending : [])]
                },
                ...columnsGroupedWithInvestment,
                {
                    column: { title: 'completed', activate: true, totalAmount: 0, finalAmount: 0, benefit: 0 },
                    users: completedInvestments ? completedInvestments : []
                }
            ];
            console.log("hi");
            return columnsGrouped;
        }
        else {
            const columns = [
                {
                    column: { title: 'created', activate: true, totalAmount: 0, finalAmount: 0, benefit: 0 },
                    users: []
                },
                {
                    column: { title: 'completed', activate: true, totalAmount: 0, finalAmount: 0, benefit: 0 },
                    users: []
                }
            ];
            return columns;
        }
    }
    async createColumnOfUnit(type, title) {
        const existingUnit = await this.unitModel.findOne({ type });
        if (!existingUnit)
            throw new common_1.NotFoundException('واحد مورد نظر یافت نشد!');
        if (existingUnit.columns?.find(item => item.title == title)) {
            return existingUnit;
        }
        else {
            existingUnit.columns?.push({ title, totalAmount: 0, finalAmount: 0, benefit: 0, activate: false });
            await existingUnit.save();
            return existingUnit;
        }
    }
    async changeActivateColumn(type, titleColumn) {
        const existingUnit = await this.unitModel.findOne({ type });
        if (!existingUnit)
            throw new common_1.NotFoundException('واحد مورد نظر یافت نشد!');
        if (existingUnit.columns) {
            const column = existingUnit.columns.find(item => item.title == titleColumn);
            if (!column)
                throw new common_1.NotFoundException('ستون مورد نظر یافت نشد!');
            column.activate = !column.activate;
            await existingUnit.save();
            return existingUnit;
        }
        return existingUnit;
    }
    async autoUpdateAmountsColumn(type, key, titleColumn) {
        const allowKeys = ['totalAmount', 'benefit'];
        if (!allowKeys.includes(key))
            throw new common_1.BadRequestException("آیتم مورد نظر یافت نشد!");
        if (key == "benefit") {
            const existingUnit = await this.unitModel.findOne({ type, 'columns.title': titleColumn });
            if (!existingUnit)
                throw new common_1.NotFoundException('واحد مورد نظر یافت نشد!');
            if (existingUnit.columns) {
                const column = existingUnit.columns.find(item => item.title == titleColumn);
                if (!column)
                    throw new common_1.NotFoundException('ستون مورد نظر یافت نشد!');
                if (column?.finalAmount && column?.totalAmount) {
                    const diff = ((column.finalAmount - column.totalAmount) * Number(column.title)) / 100;
                    column.benefit = diff;
                }
                await existingUnit.save();
                return existingUnit;
            }
            return existingUnit;
        }
        else if (key == 'totalAmount') {
            const existingUnit = await this.unitModel.findOne({ type, 'columns.title': titleColumn });
            if (!existingUnit)
                throw new common_1.NotFoundException('واحد مورد نظر یافت نشد!');
            if (existingUnit.columns) {
                const column = existingUnit.columns.find(item => item.title == titleColumn);
                if (!column)
                    throw new common_1.NotFoundException('ستون مورد نظر یافت نشد!');
                const investments = await this.investmentService.getInvestmentWithTypeAndPercent(type, Number(titleColumn));
                let totalValues = 0;
                investments.forEach(item => {
                    totalValues += item.investment.amount;
                });
                column.totalAmount = totalValues;
                await existingUnit.save();
                return existingUnit;
            }
        }
        else {
            const existingUnit = await this.unitModel.findOne({ type, 'columns.title': titleColumn });
            if (!existingUnit)
                throw new common_1.NotFoundException('واحد مورد نظر یافت نشد!');
            if (existingUnit.columns) {
                const column = existingUnit.columns.find(item => item.title == titleColumn);
                if (!column)
                    throw new common_1.NotFoundException('ستون مورد نظر یافت نشد!');
                const investments = await this.investmentService.getInvestmentWithTypeAndPercent(type, Number(titleColumn));
                let totalValues = 0;
                investments.forEach(item => {
                    totalValues += item.investment.amount;
                });
                if (column.benefit) {
                    column.totalAmount = totalValues;
                    column.finalAmount = totalValues + column.benefit;
                }
                await existingUnit.save();
                return existingUnit;
            }
            return existingUnit;
        }
    }
    async updateFinalAmountWithOnChange(type, titleColumn, finalAmount) {
        console.log(titleColumn, finalAmount);
        const existingUnit = await this.unitModel.findOne({ type });
        if (!existingUnit)
            throw new common_1.NotFoundException('واحد مورد نظر یافت نشد!');
        if (!existingUnit?.columns)
            throw new common_1.NotFoundException('ستون های واحد مورد نظر یافت نشد!');
        const column = existingUnit.columns?.find(item => item.title == titleColumn);
        if (!column)
            throw new common_1.NotFoundException('ستون مورد نظر یافت نشد!');
        if (column?.totalAmount != undefined && column?.benefit != undefined && column?.finalAmount != undefined) {
            column.finalAmount = finalAmount;
            if (finalAmount == 0) {
                column.benefit = 0;
            }
            else {
                column.benefit = ((finalAmount - column.totalAmount) / 100) * Number(titleColumn);
            }
        }
        await existingUnit.save();
        const targetColumn = existingUnit.columns.find(item => item.title == titleColumn);
        if (targetColumn != undefined) {
            if (targetColumn?.benefit != undefined && targetColumn?.totalAmount != undefined) {
                await this.investmentService.updateInvestmentsValues(type, Number(targetColumn.title), targetColumn.totalAmount, targetColumn.benefit);
            }
        }
    }
    async updateFinalAmountColumn(type, columnsUpdate) {
        const existingUnit = await this.unitModel.findOne({ type });
        if (!existingUnit)
            throw new common_1.NotFoundException('واحد مورد نظر یافت نشد!');
        const columns = existingUnit.columns;
        if (columns != undefined) {
            if (columnsUpdate) {
                await Promise.all(columnsUpdate.map(async (item) => {
                    const column = columns.find(col => col.title == item.title);
                    if (!column)
                        throw new common_1.NotFoundException('ستون یافت نشد!');
                    if (column?.finalAmount != undefined && column?.benefit != undefined && column?.totalAmount !== undefined) {
                        column.finalAmount = 0;
                        column.benefit = 0;
                    }
                }));
                await existingUnit.save();
            }
            console.log(columns);
            await Promise.all(columns.map(async (item) => {
                if (item?.totalAmount != undefined && item?.benefit != undefined) {
                    return await this.investmentService.updateInvestmentsValuesWithApplyReset(type, Number(item.title));
                }
            }));
            return existingUnit;
        }
    }
    async updateColumnAmountAddItem(type, title, amount) {
        const existingUnit = await this.unitModel.findOne({ type });
        if (!existingUnit)
            throw new common_1.NotFoundException('واحد مورد نظر یافت نشد!');
        if (existingUnit?.columns) {
            const column = existingUnit.columns.find(item => item.title == title);
            if (!column)
                throw new common_1.NotFoundException('ستون مورد نظر یافت نشد!');
            if (column?.totalAmount !== undefined && column?.finalAmount !== undefined && column?.benefit !== undefined) {
                console.log("Hi Iam Add Item", column);
                column.totalAmount = column.totalAmount + amount;
                if (column.finalAmount != 0) {
                    column.finalAmount = column.finalAmount + amount;
                }
            }
            await existingUnit.save();
            const targetColumn = existingUnit.columns.find(item => item.title == title);
            if (targetColumn) {
                console.log(targetColumn);
                if (targetColumn?.totalAmount != undefined && targetColumn?.benefit != undefined) {
                    await this.investmentService.updateInvestmentsValues(type, Number(targetColumn.title), (targetColumn.totalAmount), Number(targetColumn.benefit));
                }
            }
            return existingUnit;
        }
        return existingUnit;
    }
    async updateColumnAmountItemLeaveColumn(type, title, amount) {
        const existingUnit = await this.unitModel.findOne({ type });
        if (!existingUnit)
            throw new common_1.NotFoundException('واحد مورد نظر یافت نشد!');
        if (existingUnit?.columns) {
            const column = existingUnit.columns.find(item => item.title == title);
            if (!column)
                throw new common_1.NotFoundException('ستون مورد نظر یافت نشد!');
            if (column.totalAmount !== undefined && column.finalAmount !== undefined) {
                console.log("hi I am leave Item", column);
                if ((column.totalAmount - amount) == 0) {
                    console.log('hell');
                    column.finalAmount = 0;
                    column.benefit = 0;
                }
                else {
                    column.totalAmount = column.totalAmount - amount;
                }
            }
            await existingUnit.save();
            const targetColumn = existingUnit.columns.find(item => item.title == title);
            if (targetColumn) {
                console.log(targetColumn);
                if (targetColumn?.totalAmount != undefined && targetColumn?.benefit != undefined) {
                    await this.investmentService.updateInvestmentsValues(type, Number(targetColumn.title), (targetColumn.totalAmount), Number(targetColumn.benefit));
                }
            }
            return existingUnit;
        }
        return existingUnit;
    }
    async updateAllAmountColumn(type) {
        const existingUnit = await this.unitModel.findOne({ type });
        if (!existingUnit)
            throw new common_1.NotFoundException('واحد مورد نظر یافت نشد!');
        if (existingUnit.columns) {
            await Promise.all(existingUnit.columns.map(async (item) => {
                const investments = await this.investmentService.getInvestmentWithTypeAndPercent(type, Number(item.title));
                console.log(item.benefit, item.totalAmount, item.finalAmount, item.title, investments.length);
                if (investments.length == 0) {
                    console.log("hi length 0");
                    item.totalAmount = 0;
                    item.finalAmount = 0;
                    item.benefit = 0;
                }
                else {
                    console.log("hi length more than 0");
                    let totalValues = 0;
                    investments.forEach(inv => {
                        totalValues += inv.investment.amount;
                    });
                    console.log(totalValues);
                    item.totalAmount = totalValues;
                }
            }));
            await existingUnit.save();
            return existingUnit;
        }
    }
    async deleteColumn(type, titleColumn) {
        const existingUnit = await this.unitModel.findOne({ type });
        if (!existingUnit)
            throw new common_1.NotFoundException('واحد مورد نظر یافت نشد!');
        if (existingUnit.columns) {
            existingUnit.columns = existingUnit.columns.filter(item => item.title != titleColumn);
            await existingUnit.save();
            return existingUnit;
        }
        return existingUnit;
    }
};
exports.UnitsService = UnitsService;
exports.UnitsService = UnitsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_1.InjectModel)(unit_entity_1.Unit.name)),
    __param(2, (0, common_1.Inject)((0, common_1.forwardRef)(() => investment_service_1.InvestmentService))),
    __metadata("design:paramtypes", [mongoose_2.Model,
        created_user_service_1.CreatedUserService,
        investment_service_1.InvestmentService])
], UnitsService);
//# sourceMappingURL=units.service.js.map