"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UsersController = void 0;
const common_1 = require("@nestjs/common");
const users_service_1 = require("./users.service");
const create_user_dto_1 = require("./dto/create-user.dto");
const update_user_dto_1 = require("./dto/update-user.dto");
const platform_express_1 = require("@nestjs/platform-express");
const multer_1 = require("multer");
let UsersController = class UsersController {
    usersService;
    constructor(usersService) {
        this.usersService = usersService;
    }
    async createUserAndRequest(type, user, documents, files, titles, investments) {
        console.log(files, documents);
        const userInfo = JSON.parse(user);
        const investment = JSON.parse(investments);
        let document = JSON.parse(documents);
        let title = JSON.parse(titles);
        const newDocument = files.map((item, index) => {
            console.log({
                title: title[index],
                sourceDoc: item
            });
            document = document.filter((item) => item.title != title[index]);
            console.log(document);
            return {
                title: title[index],
                sourceDoc: item
            };
        });
        document = [...document, ...newDocument];
        console.log(document);
        return await this.usersService.createUserWithInvestment(type, userInfo, document, investment);
    }
    async register(createUserDto) {
    }
    async login(phoneNumber) {
        return await this.usersService.login(phoneNumber);
    }
    async searchUser(key, value, limit) {
        return await this.usersService.searchUser(key, value, Number(limit));
    }
    async updateUserAndRequest(type, user, investments, files, titles, documents) {
        const userInfo = JSON.parse(user);
        const investment = JSON.parse(investments);
        let document = JSON.parse(documents);
        let title = JSON.parse(titles);
        const newDocument = files.map((item, index) => {
            console.log({
                title: title[index],
                sourceDoc: item
            });
            document = document.filter((item) => item.title != title[index]);
            console.log(document);
            return {
                title: title[index],
                sourceDoc: item
            };
        });
        document = [...document, ...newDocument];
        console.log(document);
        return await this.usersService.updateUserWithInvestment(type, userInfo, document, investment);
    }
    async users() {
        const users = await this.usersService.users();
        return { message: "ok", data: users };
    }
    async findUserById(id) {
        return await this.usersService.findUserById(id);
    }
    async editUser(id, updateUserDto) {
        return this.usersService.editUser(id, updateUserDto);
    }
    async remove(id) {
        return await this.usersService.remove(id);
    }
};
exports.UsersController = UsersController;
__decorate([
    (0, common_1.Post)('create-user/investment'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('files', 10, { storage: (0, multer_1.memoryStorage)() })),
    __param(0, (0, common_1.Body)('type')),
    __param(1, (0, common_1.Body)('user')),
    __param(2, (0, common_1.Body)('documents')),
    __param(3, (0, common_1.UploadedFiles)()),
    __param(4, (0, common_1.Body)('titles')),
    __param(5, (0, common_1.Body)('investments')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, String, Array, String, String]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "createUserAndRequest", null);
__decorate([
    (0, common_1.Post)("/register"),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_user_dto_1.CreateUserDto]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "register", null);
__decorate([
    (0, common_1.Post)("/login"),
    __param(0, (0, common_1.Body)('phoneNumber')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "login", null);
__decorate([
    (0, common_1.Get)('search/user-limit'),
    __param(0, (0, common_1.Query)('key')),
    __param(1, (0, common_1.Query)('value')),
    __param(2, (0, common_1.Query)('limit')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, String]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "searchUser", null);
__decorate([
    (0, common_1.Patch)('update-user/investment'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('files', 10, { storage: (0, multer_1.memoryStorage)() })),
    __param(0, (0, common_1.Body)('type')),
    __param(1, (0, common_1.Body)('user')),
    __param(2, (0, common_1.Body)('investments')),
    __param(3, (0, common_1.UploadedFiles)()),
    __param(4, (0, common_1.Body)('titles')),
    __param(5, (0, common_1.Body)('documents')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, String, Array, String, String]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "updateUserAndRequest", null);
__decorate([
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "users", null);
__decorate([
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "findUserById", null);
__decorate([
    (0, common_1.Patch)('edit/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_user_dto_1.UpdateUserDto]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "editUser", null);
__decorate([
    (0, common_1.Delete)('/delete-user/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "remove", null);
exports.UsersController = UsersController = __decorate([
    (0, common_1.Controller)('users'),
    __metadata("design:paramtypes", [users_service_1.UsersService])
], UsersController);
//# sourceMappingURL=users.controller.js.map